@ECHO OFF

REM This script generates the bootloader for the actual device by combining the modified Atmel
REM bootloader located in BOOTDIR with the SPM helper that is being generated by make in BUILDDIR
REM Uses srec_cat to append the hex files

SET MCU=atxmega128a4u
SET PIN=PA6
SET VER=104
SET BUILDDIR=Chameleon-Mini
SET BUILDHEX=Chameleon-Mini.hex
SET BOOTDIR=Atmel-DFU-Bootloader
SET BOOTHEX=%MCU%_%VER%_%PIN%.hex
SET OUTHEX=bootloader-%MCU%-%VER%-%PIN%-SPM.hex
SET WORKDIR=%CD%

REM Enter build directory and build SPM helper
cd %BUILDDIR%
make clean 
make spmhelper MCU='%MCU%'

REM Return to working directory and combine generated HEX files into one
cd %WORKDIR%

ECHO Generating bootloader by combining %BOOTHEX% and %BUILDHEX% into %OUTHEX%
ECHO.

srec_cat %BOOTDIR%\%BOOTHEX% -intel %BUILDDIR%\%BUILDHEX% -intel -o %OUTHEX% -intel -line-length 44

ECHO Done